﻿var defaultRadioImage;
var alternateRadioImage;

$(document).ready(function () {
    var radioButton = $(".radioButton");

    adjustRadioButtonLabelPadding();

    if (defaultRadioImage) {
        $(":radio", radioButton).addClass("imageChoiceInput").hide();

        $(":radio", radioButton).each(function () {
            if ($(this).is(":checked")) {
                $(this).after("<img src='" + alternateRadioImage + "' class='radioImage choiceImage' name='" + $(this).attr("name") + "' alt='' />");
            }
            else {
                $(this).after("<img src='" + defaultRadioImage + "' class='radioImage choiceImage' name='" + $(this).attr("name") + "' alt='' />");
            }
        });

        $(".choice", radioButton).on("click", function (e) {
            if (!$(this).hasClass("disabled")) {
                var questionContent = $(this).closest(".questionContent");
                var radioImage = $(this).find(".radioImage");
                var name = radioImage.attr("name");

                $(".radioImage[name='" + name + "']", questionContent).attr("src", defaultRadioImage);
                $(":radio[name='" + name + "']", questionContent).prop("checked", false);

                radioImage.attr("src", alternateRadioImage);

                var radio = $(this).find(":radio");
                radio.prop("checked", true);
                radio.trigger("change");
                if (isInGrid(radio)) {
                    toggleGridOpenEnds(radio);
                } else {
                    toggleOpenEnd(radio, true);
                }
                e.stopPropagation();
            }
        });

        $(".choice .openEndBelow, .radioButton .choice .openEndRight", radioButton).on("click", function (e) {
            e.stopPropagation();
        });
    }
    else {
        $(".radioButton .choice :radio").on("change", function () {
            if (isInGrid($(this))) {
                toggleGridOpenEnds($(this));
            } else {
                toggleOpenEnd($(this), true);
            }
        });
    }

    $(".questionClearButton", radioButton).on("click", function (e) {
        var questionContent = $(this).closest(".questionContent");
        if (defaultRadioImage)
            $(".radioImage", questionContent).attr("src", defaultRadioImage);

        $(":radio", questionContent).prop("checked", false);
        $(":radio", questionContent).trigger("change");

        e.preventDefault();
    });

    $(".questionClearButton:image", radioButton)
        .on("mouseenter", function () {
            $(this).attr("data-defaultImg", $(this).attr("src"));

            if ($(this).attr("data-hoverimg") != "" && $(this).attr("data-hoverimg") != undefined)
                $(this).attr("src", $(this).attr("data-hoverimg"));
        })
        .on("mouseleave", function () {
            $(this).attr("src", $(this).attr("data-defaultImg"));
        });
});

function adjustRadioButtonLabelPadding() {
    if (defaultRadioImage) {
        $("body").append($("<div class='tempContainer standard'><div class='choiceList'><div class='choice'></div></div></div>"));

        $(".tempContainer .choice").append("<img src='" + alternateRadioImage + "' class='radioImage selectedImage choiceImage' />");
        $(".tempContainer .choice").append("<img src='" + defaultRadioImage + "' class='radioImage defaultImage choiceImage' />");

        $(".tempContainer").imagesLoaded(function () {
            var defaultImage = $(".tempContainer .defaultImage");
            var selectedImage = $(".tempContainer .selectedImage");

            var imageHeight = Math.max(defaultImage.height(), selectedImage.height());

            if (imageHeight > 0) {
                var paddingLeft = Math.max(defaultImage.outerWidth(true), selectedImage.outerWidth(true));
                $(".radioButton .choice label").css("line-height", imageHeight + "px");
                $(".radioButton.vertical .choice label").css("padding-left", paddingLeft + "px");
                $(".radioButton .openEndBelow").css("margin-left", paddingLeft + "px");

                $(".tempContainer").remove();
            }
        });
    }
    else {
        var paddingLeft = $(".radioButton :radio").first().outerWidth(true);
        $(".radioButton.vertical .choice label").css("padding-left", paddingLeft + "px");
        $(".radioButton .openEndBelow").css("margin-left", paddingLeft + "px");
    }
}